"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Facade on top of the gateway session to handle the logic
 * of which tools should be accessible to which agent(s) or sub-agent(s).
 * Also handles the convertion to langchain world implicitly.
 */
class ToolsProvider {
  constructor({
    session,
    logger
  }) {
    (0, _defineProperty2.default)(this, "session", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.session = session;
    this.logger = logger;
  }
  async getAllTools() {
    const allTools = await this.session.listTools();
    return allTools.map(tool => {
      return this.toLangchainTool(tool);
    });
  }
  async getBuiltInTools() {
    // TODO: fix, improve session to add meta on tools and so on
    const allTools = await this.session.listTools();
    return allTools.filter(tool => !tool.name.includes('search')).map(tool => {
      return this.toLangchainTool(tool);
    });
  }
  async getSearchTools() {
    const allTools = await this.session.listTools();
    return allTools.filter(tool => tool.name.includes('search')).map(tool => {
      return this.toLangchainTool(tool);
    });
  }
  toLangchainTool(tool) {
    return (0, _utils.toLangchainTool)({
      tool,
      session: this.session,
      logger: this.logger
    });
  }
}
exports.ToolsProvider = ToolsProvider;