"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServices = createServices;
var _integrations_service = require("./integrations/integrations_service");
var _conversations = require("./conversations");
var _chat = require("./chat");
var _orchestration = require("./orchestration");
var _agents = require("./agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createServices({
  core,
  config,
  loggerFactory,
  pluginsDependencies,
  integrationRegistry
}) {
  integrationRegistry.blockRegistration();
  const integrationsService = new _integrations_service.IntegrationsServiceImpl({
    logger: loggerFactory.get('services.integrations'),
    elasticsearch: core.elasticsearch,
    registry: integrationRegistry,
    savedObjects: core.savedObjects,
    security: core.security
  });
  const conversationService = new _conversations.ConversationServiceImpl({
    savedObjects: core.savedObjects,
    security: core.security,
    logger: loggerFactory.get('services.conversations')
  });
  const agentService = new _agents.AgentServiceImpl({
    savedObjects: core.savedObjects,
    security: core.security,
    logger: loggerFactory.get('services.agent')
  });
  const agentFactory = new _orchestration.AgentFactory({
    inference: pluginsDependencies.inference,
    tracingConfig: config.tracing,
    logger: loggerFactory.get('services.agentFactory'),
    agentService,
    integrationsService
  });
  const chatService = new _chat.ChatService({
    inference: pluginsDependencies.inference,
    logger: loggerFactory.get('services.chat'),
    agentFactory,
    conversationService
  });
  return {
    conversationService,
    agentService,
    agentFactory,
    integrationsService,
    chatService
  };
}