"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateToAttributes = exports.savedObjectToModel = exports.createRequestToRaw = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedObjectToModel = ({
  attributes
}) => {
  return {
    id: attributes.conversation_id,
    agentId: attributes.agent_id,
    title: attributes.title,
    lastUpdated: attributes.last_updated,
    user: {
      id: attributes.user_id,
      name: attributes.user_name
    },
    events: attributes.events
  };
};
exports.savedObjectToModel = savedObjectToModel;
const updateToAttributes = ({
  updatedFields
}) => {
  return {
    title: updatedFields.title,
    events: updatedFields.events
  };
};
exports.updateToAttributes = updateToAttributes;
const createRequestToRaw = ({
  conversation,
  id,
  user,
  creationDate
}) => {
  return {
    conversation_id: id,
    agent_id: conversation.agentId,
    title: conversation.title,
    last_updated: creationDate.toISOString(),
    user_id: user.id,
    user_name: user.username,
    events: conversation.events,
    access_control: {
      public: false
    }
  };
};
exports.createRequestToRaw = createRequestToRaw;