"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _conversations = require("../../saved_objects/conversations");
var _conversation_client = require("./conversation_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConversationServiceImpl {
  constructor({
    savedObjects,
    security,
    logger
  }) {
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.savedObjects = savedObjects;
    this.security = security;
    this.logger = logger;
  }
  async getScopedClient({
    request
  }) {
    const user = this.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('No user bound to the provided request');
    }
    const soClient = this.savedObjects.getScopedClient(request, {
      includedHiddenTypes: [_conversations.conversationTypeName]
    });
    return new _conversation_client.ConversationClientImpl({
      logger: this.logger.get('client'),
      client: soClient,
      user: {
        id: user.profile_uid,
        username: user.username
      }
    });
  }
}
exports.ConversationServiceImpl = ConversationServiceImpl;