"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateConversationTitle = void 0;
var _zod = require("@kbn/zod");
var _prompts = require("@langchain/core/prompts");
var _utils = require("../orchestration/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConversationTitle = async ({
  conversationEvents,
  chatModel
}) => {
  const structuredModel = chatModel.withStructuredOutput(_zod.z.object({
    title: _zod.z.string().describe('The title for the conversation')
  }));
  const prompt = _prompts.ChatPromptTemplate.fromMessages([['system', "'You are a helpful assistant. Assume the following message is the start of a conversation between you and a user; give this conversation a title based on the content below"], ['placeholder', '{messages}']]);
  const messages = (0, _utils.conversationEventsToMessages)(conversationEvents);
  const chain = prompt.pipe(structuredModel);
  const {
    title
  } = await chain.invoke({
    messages
  });
  return title;
};
exports.generateConversationTitle = generateConversationTitle;