"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateToAttributes = exports.savedObjectToModel = exports.createRequestToRaw = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedObjectToModel = ({
  attributes
}) => {
  var _attributes$avatar, _attributes$avatar2;
  return {
    id: attributes.agent_id,
    name: attributes.agent_name,
    description: attributes.description,
    lastUpdated: attributes.last_updated,
    user: {
      id: attributes.user_id,
      name: attributes.user_name
    },
    configuration: attributes.configuration,
    public: attributes.access_control.public,
    avatar: {
      color: (_attributes$avatar = attributes.avatar) === null || _attributes$avatar === void 0 ? void 0 : _attributes$avatar.color,
      text: (_attributes$avatar2 = attributes.avatar) === null || _attributes$avatar2 === void 0 ? void 0 : _attributes$avatar2.text
    }
  };
};
exports.savedObjectToModel = savedObjectToModel;
const updateToAttributes = ({
  updatedFields
}) => {
  return {
    agent_name: updatedFields.name,
    description: updatedFields.description,
    configuration: updatedFields.configuration,
    avatar: updatedFields.avatar
  };
};
exports.updateToAttributes = updateToAttributes;
const createRequestToRaw = ({
  createRequest,
  id,
  user,
  creationDate,
  color
}) => {
  return {
    agent_id: id,
    agent_name: createRequest.name,
    description: createRequest.description,
    configuration: createRequest.configuration,
    last_updated: creationDate.toISOString(),
    user_id: user.id,
    user_name: user.name,
    access_control: {
      public: createRequest.public
    },
    avatar: {
      color: color || createRequest.avatar.color,
      text: createRequest.avatar.text
    }
  };
};
exports.createRequestToRaw = createRequestToRaw;