"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.conversationTypeName = exports.conversationSoType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const conversationTypeName = exports.conversationTypeName = 'workchat_conversation';
const conversationSoType = exports.conversationSoType = {
  // TODO: specific SO index for workchat
  name: conversationTypeName,
  hidden: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: 'strict',
    properties: {
      conversation_id: {
        type: 'keyword'
      },
      agent_id: {
        type: 'keyword'
      },
      title: {
        type: 'text'
      },
      last_updated: {
        type: 'date'
      },
      events: {
        dynamic: false,
        type: 'object',
        properties: {}
      },
      user_id: {
        type: 'keyword'
      },
      user_name: {
        type: 'keyword'
      },
      access_control: {
        properties: {
          public: {
            type: 'boolean'
          }
        }
      }
    }
  }
};