"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.agentTypeName = exports.agentSoType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const agentTypeName = exports.agentTypeName = 'workchat_agent';
const agentSoType = exports.agentSoType = {
  // TODO: specific SO index for workchat
  name: agentTypeName,
  hidden: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      agent_id: {
        type: 'keyword'
      },
      agent_name: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      last_updated: {
        type: 'date'
      },
      configuration: {
        dynamic: false,
        type: 'object',
        properties: {}
      },
      user_id: {
        type: 'keyword'
      },
      user_name: {
        type: 'keyword'
      },
      access_control: {
        properties: {
          public: {
            type: 'boolean'
          }
        }
      }
    }
  }
};