"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerChatRoutes = void 0;
var _configSchema = require("@kbn/config-schema");
var _sseUtilsServer = require("@kbn/sse-utils-server");
var _features = require("../../common/features");
var _wrap_handler = require("./wrap_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerChatRoutes = ({
  getServices,
  router,
  logger
}) => {
  const wrapHandler = (0, _wrap_handler.getHandlerWrapper)({
    logger
  });
  const stubLogger = {
    debug: () => undefined,
    error: () => undefined
  };
  router.post({
    path: '/internal/workchat/chat',
    security: {
      authz: {
        requiredPrivileges: [_features.apiCapabilities.useWorkchat]
      }
    },
    validate: {
      body: _configSchema.schema.object({
        conversationId: _configSchema.schema.maybe(_configSchema.schema.string()),
        connectorId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentId: _configSchema.schema.string(),
        nextMessage: _configSchema.schema.string()
      })
    }
  }, wrapHandler(async (ctx, request, res) => {
    const {
      chatService
    } = getServices();
    const {
      nextMessage,
      conversationId,
      agentId,
      connectorId
    } = request.body;
    const abortController = new AbortController();
    request.events.aborted$.subscribe(() => {
      abortController.abort();
    });
    const events$ = chatService.converse({
      request,
      connectorId: connectorId !== null && connectorId !== void 0 ? connectorId : 'azure-gpt4',
      // TODO: auto-select on server-side when not present
      agentId,
      nextUserMessage: nextMessage,
      conversationId
    });
    return res.ok({
      headers: {
        'Content-Type': 'text/event-stream',
        'Cache-Control': 'no-cache',
        Connection: 'keep-alive'
      },
      body: (0, _sseUtilsServer.observableIntoEventSourceStream)(events$, {
        signal: abortController.signal,
        // already logging at the service level
        logger: stubLogger
      })
    });
  }));
};
exports.registerChatRoutes = registerChatRoutes;