"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWorkChatError = exports.WorkchatError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WorkchatError extends Error {
  constructor(message, statusCode = 500) {
    super(message);
    this.statusCode = statusCode;
  }
}
exports.WorkchatError = WorkchatError;
const isWorkChatError = err => {
  return err instanceof WorkchatError;
};
exports.isWorkChatError = isWorkChatError;