"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _sseUtils = require("@kbn/sse-utils");
var _sseUtilsClient = require("@kbn/sse-utils-client");
var _errors = require("../../../common/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ChatService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  converse({
    nextMessage,
    conversationId,
    agentId,
    connectorId
  }) {
    return (0, _rxjs.defer)(() => {
      return this.http.post('/internal/workchat/chat', {
        asResponse: true,
        rawResponse: true,
        body: JSON.stringify({
          nextMessage,
          conversationId,
          agentId,
          connectorId
        })
      });
    }).pipe(
    // @ts-expect-error SseEvent mixin issue
    (0, _sseUtilsClient.httpResponseIntoObservable)(), (0, _rxjs.catchError)(err => {
      if ((0, _sseUtils.isSSEError)(err)) {
        return (0, _rxjs.throwError)(() => (0, _errors.createChatError)(err.code, err.message, err.meta));
      }
      return (0, _rxjs.throwError)(() => err);
    }));
  }
}
exports.ChatService = ChatService;