"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sliceRecentConversations = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Limits the conversations array to the most recent N conversations
 */
const sliceRecentConversations = (conversations, limit) => {
  if (!limit || limit <= 0 || !(conversations !== null && conversations !== void 0 && conversations.length)) {
    return conversations || [];
  }
  return conversations.map(conversation => {
    return {
      conversation,
      date: (0, _moment.default)(conversation.lastUpdated)
    };
  }).sort((conv1, conv2) => {
    return conv2.date.valueOf() - conv1.date.valueOf();
  }).slice(0, limit).map(({
    conversation
  }) => conversation);
};
exports.sliceRecentConversations = sliceRecentConversations;