"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConversationRounds = void 0;
var _conversation_events = require("../../../common/conversation_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConversationRounds = ({
  conversationEvents,
  progressionEvents,
  chatStatus
}) => {
  const toolCallMap = new Map();
  const rounds = [];
  let current;
  conversationEvents.forEach(item => {
    if ((0, _conversation_events.isUserMessage)(item)) {
      var _current;
      if ((_current = current) !== null && _current !== void 0 && _current.userMessage) {
        throw new Error('chained user message');
      }
      if (!current) {
        current = {
          toolCalls: [],
          progressionEvents: []
        };
      }
      current.userMessage = item;
    }
    if ((0, _conversation_events.isToolResult)(item)) {
      const toolCallItem = toolCallMap.get(item.toolCallId);
      if (toolCallItem) {
        toolCallItem.toolResult = item.toolResult;
      }
    }
    if ((0, _conversation_events.isAssistantMessage)(item)) {
      if (item.toolCalls.length) {
        item.toolCalls.forEach(toolCall => {
          const roundToolCall = {
            toolCall
          };
          current.toolCalls.push(roundToolCall);
          toolCallMap.set(toolCall.toolCallId, roundToolCall);
        });
      } else {
        current.assistantMessage = item;
        rounds.push(current);
        current = undefined;
      }
    }
  });
  if (current) {
    rounds.push(current);
  }
  if (rounds.length > 0) {
    const lastRound = rounds[rounds.length - 1];
    if (progressionEvents) {
      lastRound.progressionEvents = progressionEvents;
    }
    if (chatStatus === 'loading') {
      lastRound.loading = true;
    }
  }
  return rounds;
};
exports.getConversationRounds = getConversationRounds;