"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStickToBottom = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAtBottom = parent => parent.scrollTop + parent.clientHeight >= parent.scrollHeight;
const useStickToBottom = ({
  defaultState,
  scrollContainer
}) => {
  const [stickToBottom, setStickToBottom] = (0, _react.useState)(defaultState !== null && defaultState !== void 0 ? defaultState : true);
  (0, _react.useEffect)(() => {
    const parent = scrollContainer === null || scrollContainer === void 0 ? void 0 : scrollContainer.parentElement;
    if (!parent) {
      return;
    }
    const onScroll = () => {
      setStickToBottom(isAtBottom(parent));
    };
    parent.addEventListener('scroll', onScroll);
    return () => {
      parent.removeEventListener('scroll', onScroll);
    };
  }, [scrollContainer]);
  (0, _react.useEffect)(() => {
    const parent = scrollContainer === null || scrollContainer === void 0 ? void 0 : scrollContainer.parentElement;
    if (!parent) {
      return;
    }
    if (stickToBottom) {
      parent.scrollTop = parent.scrollHeight;
    }
  });
  return {
    stickToBottom,
    setStickToBottom
  };
};
exports.useStickToBottom = useStickToBottom;