"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationList = void 0;
var _reactQuery = require("@kbn/react-query");
var _query_keys = require("../query_keys");
var _use_workchat_service = require("./use_workchat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIntegrationList = () => {
  const {
    integrationService
  } = (0, _use_workchat_service.useWorkChatServices)();
  const {
    data,
    isLoading,
    isRefetching
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.integrations.list,
    queryFn: async () => {
      return integrationService.list();
    }
  });
  const integrations = data !== null && data !== void 0 ? data : [];
  return {
    integrations,
    isLoading: isLoading || isRefetching
  };
};
exports.useIntegrationList = useIntegrationList;