"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationEdit = void 0;
var _react = require("react");
var _use_workchat_service = require("./use_workchat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyState = () => {
  return {
    name: '',
    description: '',
    type: '',
    configuration: {}
  };
};
const useIntegrationEdit = ({
  integrationId,
  onSaveSuccess,
  onSaveError
}) => {
  const {
    integrationService
  } = (0, _use_workchat_service.useWorkChatServices)();
  const [state, setState] = (0, _react.useState)(emptyState());
  const [isSubmitting, setSubmitting] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const fetchIntegration = async () => {
      if (integrationId) {
        const integration = await integrationService.get(integrationId);
        setState({
          name: integration.name,
          description: integration.description,
          type: integration.type,
          configuration: integration.configuration || {}
        });
      }
    };
    fetchIntegration();
  }, [integrationId, integrationService]);
  const submit = (0, _react.useCallback)(updatedIntegration => {
    setSubmitting(true);
    (integrationId ? integrationService.update(integrationId, {
      name: updatedIntegration.name,
      description: updatedIntegration.description,
      configuration: updatedIntegration.configuration
    }) : integrationService.create({
      type: updatedIntegration.type,
      name: updatedIntegration.name,
      description: updatedIntegration.description,
      configuration: updatedIntegration.configuration
    })).then(response => {
      setSubmitting(false);
      onSaveSuccess(response);
    }, err => {
      setSubmitting(false);
      onSaveError(err);
    });
  }, [integrationId, integrationService, onSaveSuccess, onSaveError]);
  return {
    state,
    isSubmitting,
    submit
  };
};
exports.useIntegrationEdit = useIntegrationEdit;