"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationConfigurationForm = void 0;
var _react = require("react");
var _use_workchat_service = require("./use_workchat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get the configuration form component for a specific integration type
 * @param type - The integration type
 * @returns The configuration form component or undefined if not available
 */
const useIntegrationConfigurationForm = type => {
  const {
    integrationRegistry
  } = (0, _use_workchat_service.useWorkChatServices)();
  const configurationForm = (0, _react.useMemo)(() => {
    var _integrationDefinitio;
    if (!type) return undefined;
    const integrationDefinition = integrationRegistry.get(type);
    return integrationDefinition === null || integrationDefinition === void 0 ? void 0 : (_integrationDefinitio = integrationDefinition.getConfigurationForm) === null || _integrationDefinitio === void 0 ? void 0 : _integrationDefinitio.call(integrationDefinition);
  }, [type, integrationRegistry]);
  return configurationForm;
};
exports.useIntegrationConfigurationForm = useIntegrationConfigurationForm;