"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentUser = void 0;
var _reactQuery = require("@kbn/react-query");
var _query_keys = require("../query_keys");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCurrentUser = () => {
  const {
    services: {
      security
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: user
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.users.current,
    queryFn: async () => {
      return security.authc.getCurrentUser();
    }
  });
  return user;
};
exports.useCurrentUser = useCurrentUser;