"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConversation = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_workchat_service = require("./use_workchat_service");
var _query_keys = require("../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConversation = ({
  conversationId
}) => {
  const {
    conversationService
  } = (0, _use_workchat_service.useWorkChatServices)();
  const {
    data: conversation,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.conversations.byId(conversationId !== null && conversationId !== void 0 ? conversationId : 'new'),
    queryFn: async () => {
      if (conversationId) {
        return conversationService.get(conversationId);
      }
      return undefined;
    }
  });
  return {
    conversation,
    isLoading
  };
};
exports.useConversation = useConversation;