"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumb = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _features = require("../../../common/features");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumb = breadcrumbs => {
  const {
    services: {
      chrome,
      application
    }
  } = (0, _use_kibana.useKibana)();
  const getUrl = (0, _react.useCallback)(path => {
    return application.getUrlForApp(_features.WORKCHAT_APP_ID, {
      path
    });
  }, [application]);
  const appUrl = (0, _react.useMemo)(() => {
    return getUrl('');
  }, [getUrl]);
  const baseCrumbs = (0, _react.useMemo)(() => {
    return [{
      text: _i18n.i18n.translate('workchatApp.breadcrumb.workchat', {
        defaultMessage: 'WorkChat'
      }),
      href: appUrl
    }];
  }, [appUrl]);
  (0, _react.useEffect)(() => {
    const additionalCrumbs = breadcrumbs.map(crumb => {
      return {
        text: crumb.text,
        href: crumb.path ? getUrl(crumb.path) : undefined
      };
    });
    chrome.setBreadcrumbs([...baseCrumbs, ...additionalCrumbs], {
      project: {
        value: additionalCrumbs.length ? additionalCrumbs : baseCrumbs,
        absolute: true
      }
    });
    return () => {
      chrome.setBreadcrumbs([]);
    };
  }, [chrome, baseCrumbs, breadcrumbs, getUrl]);
};
exports.useBreadcrumb = useBreadcrumb;