"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentList = void 0;
var _reactQuery = require("@kbn/react-query");
var _query_keys = require("../query_keys");
var _use_workchat_service = require("./use_workchat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentList = () => {
  const {
    agentService
  } = (0, _use_workchat_service.useWorkChatServices)();
  const {
    data: agents,
    isLoading,
    refetch: refresh
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.agents.list,
    queryFn: async () => {
      return agentService.list();
    },
    initialData: () => []
  });
  return {
    agents,
    isLoading,
    refresh
  };
};
exports.useAgentList = useAgentList;