"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentEdition = void 0;
var _react = require("react");
var _use_workchat_service = require("./use_workchat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyState = () => {
  return {
    name: '',
    description: '',
    systemPrompt: '',
    avatarColor: undefined,
    avatarCustomText: '',
    useCase: '',
    public: false
  };
};
const useAgentEdition = ({
  agentId,
  onSaveSuccess,
  onSaveError
}) => {
  const {
    agentService
  } = (0, _use_workchat_service.useWorkChatServices)();
  const [state, setState] = (0, _react.useState)(emptyState());
  const [isSubmitting, setSubmitting] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const fetchAgent = async () => {
      if (agentId) {
        var _agent$configuration$, _agent$configuration$2, _agent$avatar$text;
        const agent = await agentService.get(agentId);
        setState({
          name: agent.name,
          description: agent.description,
          systemPrompt: (_agent$configuration$ = agent.configuration.systemPrompt) !== null && _agent$configuration$ !== void 0 ? _agent$configuration$ : '',
          public: agent.public,
          useCase: (_agent$configuration$2 = agent.configuration.useCase) !== null && _agent$configuration$2 !== void 0 ? _agent$configuration$2 : '',
          avatarColor: agent.avatar.color,
          avatarCustomText: (_agent$avatar$text = agent.avatar.text) !== null && _agent$avatar$text !== void 0 ? _agent$avatar$text : ''
        });
      }
    };
    fetchAgent();
  }, [agentId, agentService]);
  const submit = (0, _react.useCallback)(updatedAgent => {
    setSubmitting(true);
    const payload = {
      name: updatedAgent.name,
      description: updatedAgent.description,
      configuration: {
        systemPrompt: updatedAgent.systemPrompt,
        useCase: updatedAgent.useCase
      },
      avatar: {
        color: updatedAgent.avatarColor,
        text: updatedAgent.avatarCustomText
      },
      public: updatedAgent.public
    };
    (agentId ? agentService.update(agentId, payload) : agentService.create(payload)).then(response => {
      setSubmitting(false);
      if (response.success) {
        onSaveSuccess(response.agent);
      }
    }, err => {
      setSubmitting(false);
      if (onSaveError) {
        onSaveError(err);
      }
    });
  }, [agentId, agentService, onSaveSuccess, onSaveError]);
  return {
    state,
    isSubmitting,
    submit
  };
};
exports.useAgentEdition = useAgentEdition;