"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationListView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../app_paths");
var _i18n2 = require("../i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationListView = ({
  tab
}) => {
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const tabs = (0, _react.useMemo)(() => {
    return [{
      id: 'active',
      label: _i18n.i18n.translate('workchatApp.integrations.listView.activeTab', {
        defaultMessage: 'Active'
      }),
      isSelected: tab === 'active',
      onClick: () => {
        navigateToWorkchatUrl(_app_paths.appPaths.tools.list);
      }
    }, {
      id: 'catalog',
      label: _i18n.i18n.translate('workchatApp.integrations.listView.catalogTab', {
        defaultMessage: 'Catalog'
      }),
      isSelected: tab === 'catalog',
      onClick: () => {
        navigateToWorkchatUrl(_app_paths.appPaths.tools.catalog);
      }
    }];
  }, [tab, navigateToWorkchatUrl]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: _i18n2.toolLabels.breadcrumb.toolsPill,
    description: _i18n.i18n.translate('workchatApp.integrations.listView.description', {
      defaultMessage: 'Connect to your tools and data so you can easily find, understand, and act on the information that matters.'
    }),
    tabs: tabs,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        return navigateToWorkchatUrl(_app_paths.appPaths.tools.create);
      },
      iconType: "plusInCircle",
      color: "primary",
      fill: true
    }, _i18n2.toolLabels.listView.addToolLabel)]
  });
};
exports.IntegrationListView = IntegrationListView;