"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationCatalogView = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _wciCommon = require("@kbn/wci-common");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _integration_list_view = require("./integration_list_view");
var _utils = require("../utils");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../app_paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationCards = {
  [_wciCommon.IntegrationType.index_source]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.importIndexCard', {
      defaultMessage: 'Import Index'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.index_source),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.importIndexDescription', {
      defaultMessage: 'Choose an existing index to connect and start using it in your workflows without re-importing your data'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.index_source)
  },
  [_wciCommon.IntegrationType.external_server]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.externalServerCard', {
      defaultMessage: 'External Server'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.external_server),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.externalServerDescription', {
      defaultMessage: 'Connect to external servers for data processing.'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.external_server)
  },
  [_wciCommon.IntegrationType.salesforce]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.salesforceCard', {
      defaultMessage: 'Salesforce'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.salesforce),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.salesforceDescription', {
      defaultMessage: 'Connect your Salesforce account to bring in customer records, case data, and account insights for use in workflows'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.salesforce)
  },
  [_wciCommon.IntegrationType.google_drive]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.googleDriveCard', {
      defaultMessage: 'Google Drive'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.google_drive),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.googleDriveDescription', {
      defaultMessage: 'Search and summarize content from your Drive files'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.google_drive)
  },
  [_wciCommon.IntegrationType.sharepoint]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.sharepointCard', {
      defaultMessage: 'Sharepoint'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.sharepoint),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.sharepointDescription', {
      defaultMessage: 'Connect internal documents and sites for enterprise-wide search.'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.sharepoint)
  },
  [_wciCommon.IntegrationType.slack]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.slackCard', {
      defaultMessage: 'Slack'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.slack),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.slackDescription', {
      defaultMessage: 'Search conversations and surface relevant team discussions.'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.slack)
  },
  [_wciCommon.IntegrationType.confluence]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.confluenceCard', {
      defaultMessage: 'Confluence'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.confluence),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.confluenceDescription', {
      defaultMessage: 'Tap into your internal knowledge base for accurate answers.'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.confluence)
  },
  [_wciCommon.IntegrationType.jira]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.jiraCard', {
      defaultMessage: 'Jira'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.jira),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.jiraDescription', {
      defaultMessage: 'Bring in issue tracking, tickets, and project context.'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.jira)
  },
  [_wciCommon.IntegrationType.github]: {
    title: _i18n.i18n.translate('workchatApp.integrations.listView.githubCard', {
      defaultMessage: 'Github'
    }),
    icon: (0, _utils.getIntegrationIcon)(_wciCommon.IntegrationType.github),
    description: _i18n.i18n.translate('workchatApp.integrations.listView.githubDescription', {
      defaultMessage: 'Search repos, issues, and documentation for engineering insights.'
    }),
    disabled: (0, _utils.isIntegrationDisabled)(_wciCommon.IntegrationType.github)
  }
};
const IntegrationCatalogView = () => {
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);
  const isLarge = (0, _eui.useIsWithinBreakpoints)(['l']);
  const columns = isMobile ? 1 : isLarge ? 2 : 3;
  const backgroundCircle = (0, _css.css)`
    background-color: ${euiTheme.colors.backgroundBaseSubdued};
    border-radius: 50%;
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-left: -10px;
    margin-right: 15px;
  `;
  const iconStyle = (0, _css.css)`
    margin-left: 8px;
    cursor: pointer;
  `;
  const titleStyle = (0, _css.css)`
    display: flex;
    align-items: center;
  `;
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    "data-test-subj": "toolsCatalogPage"
  }, /*#__PURE__*/_react.default.createElement(_integration_list_view.IntegrationListView, {
    tab: 'catalog'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    css: {
      height: 2
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('workchatApp.integrations.listView.available', {
    defaultMessage: 'Available'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: columns
  }, Object.entries(integrationCards).filter(([_, cardData]) => !cardData.disabled).map(([type, cardData]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: type
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement("div", {
      className: backgroundCircle
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: cardData.icon
    })),
    title: /*#__PURE__*/_react.default.createElement("div", {
      className: titleStyle
    }, cardData.title, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      size: "s",
      className: iconStyle
    })),
    titleSize: "xs",
    description: cardData.description,
    paddingSize: "l",
    onClick: () => {
      return navigateToWorkchatUrl(`${_app_paths.appPaths.tools.create}?type=${type}`);
    }
  }))))), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('workchatApp.integrations.listView.comingsoon', {
    defaultMessage: 'Coming soon'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: columns
  }, Object.entries(integrationCards).filter(([_, cardData]) => cardData.disabled).map(([type, cardData]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: type
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement("div", {
      className: backgroundCircle
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: cardData.icon
    })),
    title: /*#__PURE__*/_react.default.createElement("div", {
      className: titleStyle
    }, cardData.title, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      size: "s",
      className: iconStyle
    })),
    titleSize: "xs",
    description: cardData.description,
    paddingSize: "l",
    isDisabled: cardData.disabled
  }))))));
};
exports.IntegrationCatalogView = IntegrationCatalogView;