"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkChatHomeView = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _eui = require("@elastic/eui");
var _home_chat_section = require("./home_chat_section");
var _home_assistants_section = require("./home_assistants_section");
var _home_conversation_history = require("./home_conversation_history");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkChatHomeView = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    "data-test-subj": "workChatHomePage"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    "flex-direction": "column",
    restrictWidth: 800,
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_home_chat_section.HomeChatSection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_home_assistants_section.HomeAssistantsSection, null), /*#__PURE__*/_react.default.createElement(_home_conversation_history.HomeConversationHistorySection, null))));
};
exports.WorkChatHomeView = WorkChatHomeView;