"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomeChatSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _wcGenaiUtils = require("@kbn/wc-genai-utils");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _use_agent_list = require("../../hooks/use_agent_list");
var _use_navigation = require("../../hooks/use_navigation");
var _initial_message_context = require("../../context/initial_message_context");
var _use_connectors = require("../../hooks/use_connectors");
var _app_paths = require("../../app_paths");
var _chat_input_form = require("../chat/chat_input_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HomeChatSection = () => {
  const {
    agents,
    isLoading: isAgentListLoading
  } = (0, _use_agent_list.useAgentList)();
  const {
    connectors
  } = (0, _use_connectors.useConnectors)();
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    setInitialMessage
  } = (0, _initial_message_context.useInitialMessage)();
  const [selectedAgentId, setSelectedAgentId] = (0, _react.useState)('');
  const [connectorId, setConnectorId] = (0, _react.useState)(undefined);
  const theme = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(() => {
    if (agents.length > 0 && !selectedAgentId) {
      setSelectedAgentId(agents[0].id);
    }
  }, [agents, selectedAgentId]);
  (0, _react.useEffect)(() => {
    if (connectors.length && !connectorId) {
      const defaultConnector = (0, _wcGenaiUtils.getDefaultConnector)({
        connectors
      });
      if (defaultConnector) {
        setConnectorId(defaultConnector.connectorId);
      }
    }
  }, [connectorId, connectors]);
  const handleAgentChange = (0, _react.useCallback)(value => {
    setSelectedAgentId(value);
  }, []);
  const handleSubmit = (0, _react.useCallback)(message => {
    if (selectedAgentId && connectorId) {
      setInitialMessage(message);
      navigateToWorkchatUrl(_app_paths.appPaths.chat.conversation({
        agentId: selectedAgentId,
        conversationId: 'new'
      }));
    }
  }, [selectedAgentId, connectorId, setInitialMessage, navigateToWorkchatUrl]);
  const assistantSelectOptionClassName = (0, _css.css)`
    padding: ${theme.euiTheme.size.xs} 0;
  `;
  const agentOptions = [...agents.map(agent => {
    var _agent$avatar, _agent$avatar2;
    return {
      value: agent.id,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        className: assistantSelectOptionClassName
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        size: "s",
        name: agent.name,
        initials: (_agent$avatar = agent.avatar) === null || _agent$avatar === void 0 ? void 0 : _agent$avatar.text,
        color: (_agent$avatar2 = agent.avatar) === null || _agent$avatar2 === void 0 ? void 0 : _agent$avatar2.color
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, agent.name))
    };
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "l",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('workchatApp.home.welcomeWorkchat', {
    defaultMessage: 'Welcome to Workchat'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('workchatApp.home.welcomeTitle', {
    defaultMessage: 'How can we help you today?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_chat_input_form.ChatInputForm, {
    disabled: !selectedAgentId || !connectorId,
    loading: false,
    onSubmit: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, _i18n.i18n.translate('workchatApp.home.selectAssistantLabel', {
    defaultMessage: 'Chatting with'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    isLoading: isAgentListLoading,
    options: agentOptions,
    valueOfSelected: selectedAgentId,
    onChange: handleAgentChange,
    placeholder: _i18n.i18n.translate('workchatApp.home.selectAssistantPlaceholder', {
      defaultMessage: 'Select assistant'
    }),
    fullWidth: true,
    hasDividers: true
  }))));
};
exports.HomeChatSection = HomeChatSection;