"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomeAssistantsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_navigation = require("../../hooks/use_navigation");
var _use_agent_list = require("../../hooks/use_agent_list");
var _app_paths = require("../../app_paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HomeAssistantsSection = () => {
  const {
    navigateToWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    agents
  } = (0, _use_agent_list.useAgentList)();
  const assistantItems = agents.map(assistant => {
    var _assistant$avatar, _assistant$avatar2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
      key: assistant.id,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        name: assistant.name,
        initials: (_assistant$avatar = assistant.avatar) === null || _assistant$avatar === void 0 ? void 0 : _assistant$avatar.text,
        color: (_assistant$avatar2 = assistant.avatar) === null || _assistant$avatar2 === void 0 ? void 0 : _assistant$avatar2.color,
        size: "s"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        direction: "column",
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, assistant.name), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, assistant.description))),
      onClick: () => {
        navigateToWorkchatUrl(_app_paths.appPaths.chat.new({
          agentId: assistant.id
        }));
      },
      extraAction: {
        iconType: 'pencil',
        onClick: e => {
          e.stopPropagation();
          navigateToWorkchatUrl(_app_paths.appPaths.assistants.edit({
            agentId: assistant.id
          }));
        }
      },
      size: "s"
    });
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "users",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('workchatApp.home.assistants.title', {
    defaultMessage: 'Assistants'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      navigateToWorkchatUrl(_app_paths.appPaths.assistants.list);
    }
  }, _i18n.i18n.translate('workchatApp.home.assistants.viewAll', {
    defaultMessage: 'View all'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    maxWidth: false,
    gutterSize: "s"
  }, assistantItems));
};
exports.HomeAssistantsSection = HomeAssistantsSection;