"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantBlock = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _use_agent = require("../../../hooks/use_agent");
var _i18n = require("../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantBlock = ({
  agentId
}) => {
  var _agent$name, _agent$avatar, _agent$avatar2;
  const {
    agent
  } = (0, _use_agent.useAgent)({
    agentId
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const agentNameClassName = (0, _css.css)`
    font-weight: ${euiTheme.font.weight.semiBold};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    name: (_agent$name = agent === null || agent === void 0 ? void 0 : agent.name) !== null && _agent$name !== void 0 ? _agent$name : 'Assistant',
    size: "l",
    type: "user",
    initials: agent === null || agent === void 0 ? void 0 : (_agent$avatar = agent.avatar) === null || _agent$avatar === void 0 ? void 0 : _agent$avatar.text,
    color: agent === null || agent === void 0 ? void 0 : (_agent$avatar2 = agent.avatar) === null || _agent$avatar2 === void 0 ? void 0 : _agent$avatar2.color
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexStart",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    size: "s",
    isLoading: agent === undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: agentNameClassName
  }, agent === null || agent === void 0 ? void 0 : agent.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.chatCommonLabels.assistantStatus.healthy))))));
};
exports.AssistantBlock = AssistantBlock;