"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundTabAnswer = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _chat_message_text = require("./chat_message_text");
var _chat_conversation_progression = require("./chat_conversation_progression");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoundTabAnswer = ({
  round
}) => {
  var _assistantMessage$cit, _assistantMessage$con;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const {
    assistantMessage,
    progressionEvents,
    loading
  } = round;
  const showSources = !loading && ((_assistantMessage$cit = assistantMessage === null || assistantMessage === void 0 ? void 0 : assistantMessage.citations.length) !== null && _assistantMessage$cit !== void 0 ? _assistantMessage$cit : 0) > 0;
  const subTitlesClass = (0, _css.css)`
    font-weight: ${euiTheme.font.weight.bold};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_chat_conversation_progression.ChatConversationProgression, {
    progressionEvents: progressionEvents
  }), /*#__PURE__*/_react.default.createElement(_chat_message_text.ChatMessageText, {
    content: (_assistantMessage$con = assistantMessage === null || assistantMessage === void 0 ? void 0 : assistantMessage.content) !== null && _assistantMessage$con !== void 0 ? _assistantMessage$con : '',
    loading: loading && progressionEvents.length === 0
  })), showSources && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: subTitlesClass
  }, "Sources - Most relevant"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    direction: "row",
    columns: isMobile ? 2 : 3
  }, assistantMessage.citations.slice(0, 3).map(ref => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SourceSummary, {
    key: `${ref.sourceId}-${ref.contentId}`,
    contentRef: ref
  }))))));
};
exports.RoundTabAnswer = RoundTabAnswer;
const SourceSummary = ({
  contentRef
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const panelClass = (0, _css.css)`
    cursor: pointer;
    border: ${euiTheme.border.thin};

    &:hover {
      border-color: ${euiTheme.colors.borderBaseFormsControl};
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: panelClass,
    hasShadow: false,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "database",
    color: "primary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: euiTheme.colors.link
  }, contentRef.sourceId))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, contentRef.contentId))));
};