"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatConversationRound = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _round_tab_answer = require("./round_tab_answer");
var _round_tab_sources = require("./round_tab_sources");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatConversationRound = ({
  round
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    userMessage,
    loading: isRoundLoading,
    assistantMessage
  } = round;
  const rootPanelClass = (0, _css.css)`
    margin-bottom: ${euiTheme.size.xl};
  `;
  const tabsContainerClass = (0, _css.css)`
    border-bottom: ${euiTheme.border.thin};
    padding: 0 ${euiTheme.size.xxl};
  `;
  const tabContentPanelClass = (0, _css.css)`
    padding: ${euiTheme.size.xxl};
  `;
  const userTextContainerClass = (0, _css.css)`
    padding: ${euiTheme.size.xxl} ${euiTheme.size.xxl} ${euiTheme.size.xl} ${euiTheme.size.xxl};
  `;
  const userMessageTextClass = (0, _css.css)`
    font-weight: ${euiTheme.font.weight.regular};
    font-size: calc(${(0, _eui.useEuiFontSize)('m').fontSize} + 4px);
  `;
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)('answer');
  const tabs = (0, _react.useMemo)(() => {
    const tabList = [];

    // main answer tab, always present
    tabList.push({
      id: 'answer',
      name: 'Answer',
      append: undefined
    });

    // sources tab - only when we got sources and message is not loading
    if (!isRoundLoading && assistantMessage !== null && assistantMessage !== void 0 && assistantMessage.citations.length) {
      tabList.push({
        id: 'sources',
        name: 'Sources',
        append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
          size: "m",
          color: "subdued"
        }, assistantMessage.citations.length)
      });
    }
    return tabList;
  }, [isRoundLoading, assistantMessage]);
  const onSourceClick = (0, _react.useCallback)(() => {
    setSelectedTabId('sources');
  }, [setSelectedTabId]);
  const tabContents = (0, _react.useMemo)(() => {
    return {
      answer: /*#__PURE__*/_react.default.createElement(_round_tab_answer.RoundTabAnswer, {
        key: `round-${round.userMessage.id}-answer-tab`,
        round: round,
        onSourceClick: onSourceClick
      }),
      sources: /*#__PURE__*/_react.default.createElement(_round_tab_sources.RoundTabSources, {
        key: `round-${round.userMessage.id}-sources-tab`,
        round: round
      })
    };
  }, [round, onSourceClick]);
  const selectedTabContent = (0, _react.useMemo)(() => {
    return tabContents[selectedTabId];
  }, [tabContents, selectedTabId]);
  const onSelectedTabChanged = id => {
    setSelectedTabId(id);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: rootPanelClass,
    borderRadius: "none",
    paddingSize: "none",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: userTextContainerClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "m",
    className: userMessageTextClass
  }, "\u201C", userMessage.content, "\u201C")), /*#__PURE__*/_react.default.createElement("div", {
    className: tabsContainerClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false
  }, tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    append: tab.append
  }, tab.name)))), /*#__PURE__*/_react.default.createElement("div", {
    className: tabContentPanelClass
  }, selectedTabContent));
};
exports.ChatConversationRound = ChatConversationRound;