"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chat = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _use_chat = require("../../hooks/use_chat");
var _use_conversation = require("../../hooks/use_conversation");
var _use_stick_to_bottom = require("../../hooks/use_stick_to_bottom");
var _initial_message_context = require("../../context/initial_message_context");
var _chat_input_form = require("./chat_input_form");
var _chat_conversation = require("./conversation/chat_conversation");
var _chat_new_conversation_prompt = require("./chat_new_conversation_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const conversationPanelClass = (0, _css.css)`
  min-height: 100%;
  max-width: 850px;
  margin-left: auto;
  margin-right: auto;
`;
const scrollContainerClassName = scrollBarStyles => (0, _css.css)`
  overflow-y: auto;
  ${scrollBarStyles}
`;
const Chat = ({
  agentId,
  conversationId,
  currentUser,
  onConversationUpdate,
  connectorId
}) => {
  const {
    conversation
  } = (0, _use_conversation.useConversation)({
    conversationId
  });
  const {
    initialMessage,
    clearInitialMessage
  } = (0, _initial_message_context.useInitialMessage)();
  const {
    sendMessage,
    conversationEvents,
    setConversationEvents,
    progressionEvents,
    status: chatStatus
  } = (0, _use_chat.useChat)({
    conversationId,
    connectorId,
    agentId,
    onConversationUpdate
  });
  (0, _react.useEffect)(() => {
    var _conversation$events;
    setConversationEvents((_conversation$events = conversation === null || conversation === void 0 ? void 0 : conversation.events) !== null && _conversation$events !== void 0 ? _conversation$events : []);
  }, [conversation, setConversationEvents]);
  (0, _react.useEffect)(() => {
    if (initialMessage && agentId && connectorId) {
      sendMessage(initialMessage);
      clearInitialMessage();
    }
  }, [initialMessage, agentId, connectorId, sendMessage, clearInitialMessage]);
  const theme = (0, _eui.useEuiTheme)();
  const scrollBarStyles = (0, _eui.euiScrollBarStyles)(theme);
  const scrollContainerRef = (0, _react.useRef)(null);
  const {
    setStickToBottom
  } = (0, _use_stick_to_bottom.useStickToBottom)({
    defaultState: true,
    scrollContainer: scrollContainerRef.current
  });
  (0, _react.useEffect)(() => {
    setStickToBottom(true);
  }, [conversationId, setStickToBottom]);
  const onSubmit = (0, _react.useCallback)(message => {
    setStickToBottom(true);
    sendMessage(message);
  }, [sendMessage, setStickToBottom]);
  if (!conversationId && conversationEvents.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_chat_new_conversation_prompt.ChatNewConversationPrompt, {
      agentId: agentId,
      onSubmit: onSubmit
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: scrollContainerClassName(scrollBarStyles)
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollContainerRef,
    className: fullHeightClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    className: conversationPanelClass
  }, /*#__PURE__*/_react.default.createElement(_chat_conversation.ChatConversation, {
    conversationEvents: conversationEvents,
    progressionEvents: progressionEvents,
    chatStatus: chatStatus,
    currentUser: currentUser
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chat_input_form.ChatInputForm, {
    disabled: !agentId || !connectorId,
    loading: false,
    onSubmit: onSubmit
  })));
};
exports.Chat = Chat;