"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assistantLabels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assistantLabels = exports.assistantLabels = {
  breadcrumb: {
    assistantsPill: _i18n.i18n.translate('workchatApp.assistants.breadcrumb.assistants', {
      defaultMessage: 'Assistants'
    }),
    assistantDetailsPill: _i18n.i18n.translate('workchatApp.assistants.breadcrumb.assistantOverview', {
      defaultMessage: 'Overview'
    }),
    assistantWorkflowPill: _i18n.i18n.translate('workchatApp.assistants.breadcrumb.assistantWorkflow', {
      defaultMessage: 'Workflows'
    })
  },
  notifications: {
    assistantCreatedToastText: _i18n.i18n.translate('workchatApp.assistants.notifications.assistantCreatedToastText', {
      defaultMessage: 'Assistant created'
    }),
    assistantUpdatedToastText: _i18n.i18n.translate('workchatApp.assistants.notifications.assistantCreatedToastText', {
      defaultMessage: 'Assistant updated'
    })
  },
  editView: {
    createassistantTitle: _i18n.i18n.translate('workchatApp.assistants.editView.createTitle', {
      defaultMessage: 'Create a new assistant'
    }),
    editassistantTitle: _i18n.i18n.translate('workchatApp.assistants.editView.editTitle', {
      defaultMessage: 'Edit assistant'
    }),
    cancelButtonLabel: _i18n.i18n.translate('workchatApp.assistants.editView.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    saveButtonLabel: _i18n.i18n.translate('workchatApp.assistants.editView.saveButtonLabel', {
      defaultMessage: 'Save'
    }),
    editButtonLabel: _i18n.i18n.translate('workchatApp.assistants.editView.editButtonLabel', {
      defaultMessage: 'Edit'
    })
  }
};