"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _use_navigation = require("../../../hooks/use_navigation");
var _use_breadcrumbs = require("../../../hooks/use_breadcrumbs");
var _app_paths = require("../../../app_paths");
var _i18n2 = require("../i18n");
var _use_agent = require("../../../hooks/use_agent");
var _use_conversation_list = require("../../../hooks/use_conversation_list");
var _sort_and_group_conversations = require("../../../utils/sort_and_group_conversations");
var _slice_recent_conversations = require("../../../utils/slice_recent_conversations");
var _assistant_edit_basic_info_modal = require("./assistant_edit_basic_info_modal");
var _assistant_edit_prompt_modal = require("./assistant_edit_prompt_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssistantDetails = ({
  agentId
}) => {
  const {
    navigateToWorkchatUrl,
    createWorkchatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    agent: assistant,
    isLoading,
    refetch
  } = (0, _use_agent.useAgent)({
    agentId
  });
  const {
    conversations
  } = (0, _use_conversation_list.useConversationList)({
    agentId
  });

  // State for modals
  const [isBasicInfoModalVisible, setIsBasicInfoModalVisible] = (0, _react.useState)(false);
  const [isPromptModalVisible, setIsPromptModalVisible] = (0, _react.useState)(false);
  const conversationGroups = (0, _react.useMemo)(() => {
    return (0, _sort_and_group_conversations.sortAndGroupConversations)((0, _slice_recent_conversations.sliceRecentConversations)(conversations, 10));
  }, [conversations]);
  const breadcrumb = (0, _react.useMemo)(() => {
    return [{
      text: _i18n2.assistantLabels.breadcrumb.assistantsPill,
      href: createWorkchatUrl(_app_paths.appPaths.assistants.list)
    }, {
      text: _i18n2.assistantLabels.breadcrumb.assistantDetailsPill
    }];
  }, [createWorkchatUrl]);
  (0, _use_breadcrumbs.useBreadcrumb)(breadcrumb);
  const handleOpenBasicInfoModal = (0, _react.useCallback)(() => {
    setIsBasicInfoModalVisible(true);
  }, []);
  const handleCloseBasicInfoModal = (0, _react.useCallback)(() => {
    setIsBasicInfoModalVisible(false);
  }, []);
  const handleOpenPromptModal = (0, _react.useCallback)(() => {
    setIsPromptModalVisible(true);
  }, []);
  const handleClosePromptModal = (0, _react.useCallback)(() => {
    setIsPromptModalVisible(false);
  }, []);
  const handleSaveSuccess = (0, _react.useCallback)(() => {
    refetch();
  }, [refetch]);
  if (isLoading || !assistant) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, null));
  }
  const AssistantBasicInfo = () => {
    var _assistant$avatar, _assistant$avatar2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      direction: "row",
      gutterSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      size: "xl",
      name: assistant.name,
      initials: (_assistant$avatar = assistant.avatar) === null || _assistant$avatar === void 0 ? void 0 : _assistant$avatar.text,
      color: (_assistant$avatar2 = assistant.avatar) === null || _assistant$avatar2 === void 0 ? void 0 : _assistant$avatar2.color
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("span", null, assistant.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, assistant.description)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "pencil",
      color: "text",
      onClick: handleOpenBasicInfoModal,
      "data-test-subj": "editAssistantBasicInfoButton"
    }, _i18n2.assistantLabels.editView.editButtonLabel))));
  };
  const AssistantPrompt = () => {
    var _assistant$configurat;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      color: "subdued"
    }, assistant === null || assistant === void 0 ? void 0 : (_assistant$configurat = assistant.configuration) === null || _assistant$configurat === void 0 ? void 0 : _assistant$configurat.systemPrompt)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "pencil",
      color: "text",
      onClick: handleOpenPromptModal,
      "data-test-subj": "editAssistantPromptButton"
    }, _i18n2.assistantLabels.editView.editButtonLabel))));
  };
  const AssistantChatHistory = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, conversationGroups.map(({
    conversations: groupConversations,
    dateLabel
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: dateLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, dateLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, groupConversations.map(conversation => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: conversation.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "subdued",
    onClick: () => {
      navigateToWorkchatUrl(_app_paths.appPaths.chat.conversation({
        agentId: assistant.id,
        conversationId: conversation.id
      }));
    }
  }, conversation.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    alignItems: "flexStart",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('workchatApp.assistants.basicInfoTitle', {
    defaultMessage: 'Basic'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(AssistantBasicInfo, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "gear",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('workchatApp.assistants.promptTitle', {
    defaultMessage: 'Prompt'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(AssistantPrompt, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "list",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('workchatApp.home.recentConversations.title', {
    defaultMessage: 'Recent conversations'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(AssistantChatHistory, null)))), isBasicInfoModalVisible && /*#__PURE__*/_react.default.createElement(_assistant_edit_basic_info_modal.EditAssistantBasicInfo, {
    agentId: agentId,
    onClose: handleCloseBasicInfoModal,
    onSaveSuccess: handleSaveSuccess
  }), isPromptModalVisible && /*#__PURE__*/_react.default.createElement(_assistant_edit_prompt_modal.EditPrompt, {
    agentId: agentId,
    onClose: handleClosePromptModal,
    onSaveSuccess: handleSaveSuccess
  }));
};
exports.AssistantDetails = AssistantDetails;