"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUserMessage = exports.isToolResult = exports.isAssistantMessage = exports.createUserMessage = exports.createToolResult = exports.createAssistantMessage = exports.ConversationEventType = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ConversationEventType = exports.ConversationEventType = /*#__PURE__*/function (ConversationEventType) {
  ConversationEventType["userMessage"] = "user_message";
  ConversationEventType["assistantMessage"] = "assistant_message";
  ConversationEventType["toolResult"] = "tool_result";
  return ConversationEventType;
}({});
/**
 * Base interface for conversation events
 */
/**
 * Represents a message from the user.
 */
/**
 * Represents a message from the assistant
 */
/**
 * Represents a tool being executed
 */
/**
 * Composite of all possible conversation event types
 */
/**
 * Represents a tool call that was requested by the assistant
 */
const createUserMessage = parts => {
  var _parts$id, _parts$createdAt;
  return {
    type: ConversationEventType.userMessage,
    id: (_parts$id = parts.id) !== null && _parts$id !== void 0 ? _parts$id : (0, _uuid.v4)(),
    content: parts.content,
    createdAt: (_parts$createdAt = parts.createdAt) !== null && _parts$createdAt !== void 0 ? _parts$createdAt : new Date().toISOString()
  };
};
exports.createUserMessage = createUserMessage;
const createAssistantMessage = parts => {
  var _parts$id2, _parts$content, _parts$toolCalls, _parts$citations, _parts$createdAt2;
  return {
    type: ConversationEventType.assistantMessage,
    id: (_parts$id2 = parts.id) !== null && _parts$id2 !== void 0 ? _parts$id2 : (0, _uuid.v4)(),
    content: (_parts$content = parts.content) !== null && _parts$content !== void 0 ? _parts$content : '',
    toolCalls: (_parts$toolCalls = parts.toolCalls) !== null && _parts$toolCalls !== void 0 ? _parts$toolCalls : [],
    citations: (_parts$citations = parts.citations) !== null && _parts$citations !== void 0 ? _parts$citations : [],
    createdAt: (_parts$createdAt2 = parts.createdAt) !== null && _parts$createdAt2 !== void 0 ? _parts$createdAt2 : new Date().toISOString()
  };
};
exports.createAssistantMessage = createAssistantMessage;
const createToolResult = parts => {
  var _parts$id3, _parts$createdAt3;
  return {
    type: ConversationEventType.toolResult,
    id: (_parts$id3 = parts.id) !== null && _parts$id3 !== void 0 ? _parts$id3 : (0, _uuid.v4)(),
    toolCallId: parts.toolCallId,
    toolResult: parts.toolResult,
    createdAt: (_parts$createdAt3 = parts.createdAt) !== null && _parts$createdAt3 !== void 0 ? _parts$createdAt3 : new Date().toISOString()
  };
};
exports.createToolResult = createToolResult;
const isUserMessage = event => {
  return event.type === ConversationEventType.userMessage;
};
exports.isUserMessage = isUserMessage;
const isAssistantMessage = event => {
  return event.type === ConversationEventType.assistantMessage;
};
exports.isAssistantMessage = isAssistantMessage;
const isToolResult = event => {
  return event.type === ConversationEventType.toolResult;
};
exports.isToolResult = isToolResult;