"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectToInternalServer = void 0;
var _inMemory = require("@modelcontextprotocol/sdk/inMemory.js");
var _index = require("@modelcontextprotocol/sdk/client/index.js");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a {@link McpProviderFn} that will run the provided server in memory
 * and connect to it.
 */
const getConnectToInternalServer = ({
  server,
  clientName = 'unknown'
}) => {
  let connected = false;
  return async function connect() {
    if (connected) {
      throw new Error('Client already connected');
    }
    connected = true;
    const [clientTransport, serverTransport] = _inMemory.InMemoryTransport.createLinkedPair();
    const client = new _index.Client({
      name: clientName,
      version: '1.0.0'
    });
    await server.connect(clientTransport);
    await client.connect(serverTransport);
    const disconnect = async () => {
      await client.close();
      await server.close();
    };
    return Object.assign(client, {
      disconnect
    });
  };
};
exports.getConnectToInternalServer = getConnectToInternalServer;