"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectToExternalServer = void 0;
var _index = require("@modelcontextprotocol/sdk/client/index.js");
var _sse = require("@modelcontextprotocol/sdk/client/sse.js");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectToExternalServer = ({
  serverUrl,
  clientName = 'unknown'
}) => {
  let connected = false;
  return async function connect() {
    if (connected) {
      throw new Error('Client already connected');
    }
    connected = true;
    const transport = new _sse.SSEClientTransport(new URL(serverUrl));
    const client = new _index.Client({
      name: clientName,
      version: '1.0.0'
    }, {
      capabilities: {
        prompts: {},
        resources: {},
        tools: {}
      }
    });
    await client.connect(transport);
    const disconnect = async () => {
      await client.close();
    };
    return Object.assign(client, {
      disconnect
    });
  };
};
exports.getConnectToExternalServer = getConnectToExternalServer;