"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSalesforceIntegrationDefinition = void 0;
var _wciCommon = require("@kbn/wci-common");
var _wciServer = require("@kbn/wci-server");
var _mcp_server = require("./mcp_server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSalesforceIntegrationDefinition = ({
  core,
  logger
}) => {
  return {
    getType: () => _wciCommon.IntegrationType.salesforce,
    createIntegration: async ({
      request,
      integrationId,
      configuration
    }) => {
      const [coreStart] = await core.getStartServices();
      const elasticsearchClient = coreStart.elasticsearch.client.asScoped(request).asCurrentUser;
      const mcpServer = await (0, _mcp_server.createMcpServer)({
        integrationId,
        configuration,
        elasticsearchClient,
        logger
      });
      return {
        connect: (0, _wciServer.getConnectToInternalServer)({
          server: mcpServer
        })
      };
    }
  };
};
exports.getSalesforceIntegrationDefinition = getSalesforceIntegrationDefinition;