"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SalesforceConfigurationForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SalesforceConfigurationForm = ({
  form
}) => {
  const {
    control
  } = form;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    ratio: "third",
    title: /*#__PURE__*/_react.default.createElement("h3", null, "Salesforce Configuration"),
    description: "Configure the salesforce details"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Index"
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.index",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "workchatAppIntegrationEditViewIndex",
      placeholder: "Enter index name"
    }, field))
  })));
};
exports.SalesforceConfigurationForm = SalesforceConfigurationForm;