"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WCIIndexSourcePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _routes = require("./routes");
var _integration = require("./integration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WCIIndexSourcePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(core, {
    workchatApp
  }) {
    const router = core.http.createRouter();
    (0, _routes.registerRoutes)({
      core,
      logger: this.logger,
      router
    });
    workchatApp.integrations.register((0, _integration.getIndexSourceIntegrationDefinition)({
      core,
      logger: this.logger
    }));
    return {};
  }
  start(core, pluginsDependencies) {
    return {};
  }
}
exports.WCIIndexSourcePlugin = WCIIndexSourcePlugin;