"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSourceTool = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bold = (0, _css.css)`
  font-weight: bold;
  font-style: normal;
`;
const italic = (0, _css.css)`
  font-style: italic;
`;
const IndexSourceTool = ({
  integration,
  toolCall,
  toolResult
}) => {
  const integrationNode = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: bold,
    color: "success"
  }, integration.name);
  const argsNode = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: bold,
    color: "accent"
  }, "\"", toolCall.args.query, "\"");
  if (toolResult) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: italic
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.workchatApp.wci_index_source.chat.toolCall.calledToolLabel",
      defaultMessage: "searched for {args} using index source {integration}.",
      values: {
        integration: integrationNode,
        args: argsNode
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: italic
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.workchatApp.wci_index_source.chat.toolCall.callingToolLabel",
      defaultMessage: "is searching for {args} using index source {integration}.",
      values: {
        integration: integrationNode,
        args: argsNode
      }
    }));
  }
};
exports.IndexSourceTool = IndexSourceTool;