"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexNameAutocomplete = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndexNameAutocomplete = ({
  query
}) => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _public.useKibana)();
  const [debouncedQuery, setDebounceQuery] = (0, _react.useState)(query);
  (0, _useDebounce.default)(() => {
    setDebounceQuery(query);
  }, 250, [query]);
  const {
    isLoading,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['index-name-autocomplete', debouncedQuery],
    queryFn: async () => {
      if (query.length < 3) {
        return [];
      }
      const response = await http.get(`/internal/wci-index-source/indices-autocomplete`, {
        query: {
          index: query
        }
      });
      return response.indexNames;
    },
    initialData: [],
    onError: err => {
      notifications.toasts.addError(err, {
        title: 'Error fetching indices'
      });
    }
  });
  return {
    isLoading,
    data
  };
};
exports.useIndexNameAutocomplete = useIndexNameAutocomplete;