"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeContentRef = exports.parseContentRef = exports.contentRefBuilder = exports.ContentRefSourceType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ContentRefSourceType = exports.ContentRefSourceType = /*#__PURE__*/function (ContentRefSourceType) {
  ContentRefSourceType["integration"] = "integration";
  return ContentRefSourceType;
}({});
/**
 * Represents a reference to a content
 */
/**
 * Serialize a {@link ContentRef} to a string representation.
 */
const serializeContentRef = ref => {
  return `ref||${ref.sourceType}||${ref.sourceId}||${ref.contentId}`;
};

/**
 * Parses a serialized ref back.
 */
exports.serializeContentRef = serializeContentRef;
const parseContentRef = serializedRef => {
  const parts = serializedRef.split('||');
  if (parts.length !== 4) {
    throw new Error(`Trying to parse ref with invalid format: ${serializedRef}`);
  }
  return {
    sourceType: parts[1],
    sourceId: parts[2],
    contentId: parts[3]
  };
};
exports.parseContentRef = parseContentRef;
const contentRefBuilder = ({
  sourceId,
  sourceType
}) => contentId => ({
  sourceId,
  sourceType,
  contentId
});
exports.contentRefBuilder = contentRefBuilder;