"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hitToContent = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hitToContent = ({
  hit,
  fields
}) => {
  const content = {};
  fields.forEach(field => {
    var _hit$highlight;
    if ((_hit$highlight = hit.highlight) !== null && _hit$highlight !== void 0 && _hit$highlight[field]) {
      var _hit$highlight2;
      content[field] = (_hit$highlight2 = hit.highlight) === null || _hit$highlight2 === void 0 ? void 0 : _hit$highlight2[field];
    } else {
      var _hit$_source;
      content[field] = (0, _lodash.get)((_hit$_source = hit._source) !== null && _hit$_source !== void 0 ? _hit$_source : {}, field);
    }
  });
  return content;
};
exports.hitToContent = hitToContent;