"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSearchSchema = exports.generateFilterSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSearchSchema = ({
  filters
}) => {
  return filters.reduce((schema, filter) => {
    return {
      ...schema,
      ...generateFilterSchema({
        filter
      })
    };
  }, {
    query: _zod.z.string().describe('A query to use for fulltext search').optional()
  });
};
exports.generateSearchSchema = generateSearchSchema;
const generateFilterSchema = ({
  filter
}) => {
  switch (filter.type) {
    case 'keyword':
      if (filter.values && filter.values.length > 0) {
        return {
          [filter.field]: _zod.z.enum(filter.values).describe(filter.description).optional()
        };
      } else {
        return {
          [filter.field]: _zod.z.string().describe(filter.description).optional()
        };
      }
    case 'date':
      return {
        [filter.field]: _zod.z.string().datetime({
          offset: true
        }).describe(`${filter.description} - use ISO 8601 format`).optional()
      };
    case 'boolean':
      return {
        [filter.field]: _zod.z.boolean().describe(filter.description).optional()
      };
    default:
      return {};
  }
};
exports.generateFilterSchema = generateFilterSchema;