"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldsTopValues = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldsTopValues = async ({
  indexName,
  fieldNames,
  esClient,
  maxSize = 20
}) => {
  const aggResult = await esClient.search({
    index: indexName,
    size: 0,
    aggs: Object.fromEntries(fieldNames.map(field => [field, {
      terms: {
        field,
        size: maxSize
      }
    }]))
  });
  const aggregations = aggResult.aggregations;
  const topValues = fieldNames.reduce((map, fieldName) => {
    const aggr = aggregations[fieldName];
    if (aggr.buckets && Array.isArray(aggr.buckets)) {
      // key | doc_count
      const values = aggr.buckets.map(bucket => bucket.key);
      map[fieldName] = values;
    }

    // aggr.buckets[0]

    return map;
  }, {});
  return topValues;
};
exports.getFieldsTopValues = getFieldsTopValues;