"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicensePrompt = ({
  message,
  licenseManagementLocator
}) => {
  const licenseManagementUrl = licenseManagementLocator === null || licenseManagementLocator === void 0 ? void 0 : licenseManagementLocator.useUrl({
    page: 'dashboard'
  });
  // if there is no licenseManagementUrl, the license management plugin might be disabled
  const promptAction = licenseManagementUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: licenseManagementUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.app.licenseErrorLinkText",
    defaultMessage: "Manage your license"
  })) : undefined;
  const promptBody = licenseManagementUrl ? /*#__PURE__*/_react.default.createElement("p", null, message) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, message), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.watcher.app.licenseErrorBody",
    defaultMessage: "Contact your administrator to change your license."
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.app.licenseErrorTitle",
      defaultMessage: "License error"
    })),
    body: promptBody,
    actions: [promptAction]
  });
};
exports.LicensePrompt = LicensePrompt;