"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
var _charts = require("@elastic/charts");
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _types = require("../../types");
var _common = require("../../utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getYScaleType(scale) {
  const type = scale === null || scale === void 0 ? void 0 : scale.type;
  if (type === _types.ScaleType.SquareRoot) {
    return _charts.ScaleType.Sqrt;
  }
  return type;
}
function getXScaleType(xColumn) {
  if ((xColumn === null || xColumn === void 0 ? void 0 : xColumn.dataType) === 'date') return _charts.ScaleType.Time;
  if ((xColumn === null || xColumn === void 0 ? void 0 : xColumn.dataType) !== 'number') {
    return _charts.ScaleType.Ordinal;
  }
  return _charts.ScaleType.Linear;
}
function getLabelOrientation(data, isTimeChart = false) {
  var _data$labels$rotate;
  // lens doesn't support 75 as rotate option, we should use 45 instead
  return -((data === null || data === void 0 ? void 0 : data.labels.rotate) === 75 ? 45 : (_data$labels$rotate = data === null || data === void 0 ? void 0 : data.labels.rotate) !== null && _data$labels$rotate !== void 0 ? _data$labels$rotate : isTimeChart ? 0 : 90);
}
function getExtents(axis, series) {
  // for area and bar charts we should include 0 to bounds
  const isAssignedToAreaOrBar = series.some(s => s.valueAxis === axis.id && (s.type === 'histogram' || s.type === 'area'));
  return {
    mode: (0, _common.getMode)(axis.scale),
    lowerBound: axis.scale.min !== null ? isAssignedToAreaOrBar && axis.scale.min && axis.scale.min > 0 ? 0 : axis.scale.min : undefined,
    upperBound: axis.scale.max !== null ? isAssignedToAreaOrBar && axis.scale.max && axis.scale.max < 0 ? 0 : axis.scale.max : undefined,
    enforce: true
  };
}
function getSeriesType(type, mode, isHorizontal, isPercentage) {
  let seriesType = type === 'histogram' ? _convert_to_lens.SeriesTypes.BAR : type !== null && type !== void 0 ? type : _convert_to_lens.SeriesTypes.AREA;

  // only bar chart supports horizontal mode
  if (isHorizontal && seriesType === _convert_to_lens.SeriesTypes.BAR) {
    seriesType = seriesType + '_horizontal';
  }

  // line percentage should convert to area percentage
  if (isPercentage) {
    seriesType = (seriesType !== _convert_to_lens.SeriesTypes.LINE ? seriesType : _convert_to_lens.SeriesTypes.AREA) + '_percentage';
  }

  // percentage chart should be stacked
  // line stacked should convert to area stacked
  if (isPercentage || mode === 'stacked') {
    seriesType = (seriesType !== _convert_to_lens.SeriesTypes.LINE ? seriesType : _convert_to_lens.SeriesTypes.AREA) + '_stacked';
  }
  return seriesType;
}
function getDataLayers(layers, series, vis) {
  const overwriteColors = vis.uiState.get('vis.colors', {});
  return layers.map(layer => {
    var _layer$columns$find, _vis$params$valueAxes, _vis$params$palette;
    const xColumn = layer.columns.find(c => c.isBucketed && !c.isSplit);
    const splitAccessor = (_layer$columns$find = layer.columns.find(column => column.isBucketed && column.isSplit)) === null || _layer$columns$find === void 0 ? void 0 : _layer$columns$find.columnId;
    // as type and mode will be the same for all metrics we can use first to define it
    const firstSeries = series.find(s => s.data.id === layer.seriesIdsMap[layer.metrics[0]]);
    const isHistogram = (xColumn === null || xColumn === void 0 ? void 0 : xColumn.operationType) === 'date_histogram' || (xColumn === null || xColumn === void 0 ? void 0 : xColumn.operationType) === 'range' && xColumn.params.type === 'histogram';
    const firstYAxis = ((_vis$params$valueAxes = vis.params.valueAxes) !== null && _vis$params$valueAxes !== void 0 ? _vis$params$valueAxes : vis.type.visConfig.defaults.valueAxes).find(axis => axis.id === (firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.valueAxis));
    const isPercentage = (firstYAxis === null || firstYAxis === void 0 ? void 0 : firstYAxis.scale.mode) === 'percentage';
    const isHorizontal = (firstYAxis === null || firstYAxis === void 0 ? void 0 : firstYAxis.position) !== _charts.Position.Left && (firstYAxis === null || firstYAxis === void 0 ? void 0 : firstYAxis.position) !== _charts.Position.Right;
    const seriesType = getSeriesType(firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.type, firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.mode, isHorizontal, isPercentage);
    return {
      layerId: layer.layerId,
      accessors: layer.metrics,
      layerType: 'data',
      seriesType,
      xAccessor: xColumn === null || xColumn === void 0 ? void 0 : xColumn.columnId,
      simpleView: false,
      splitAccessor,
      palette: (_vis$params$palette = vis.params.palette) !== null && _vis$params$palette !== void 0 ? _vis$params$palette : vis.type.visConfig.defaults.palette,
      yConfig: layer.metrics.map(metricId => {
        var _vis$params$valueAxes2, _yAxis$position;
        const serie = series.find(s => s.data.id === layer.seriesIdsMap[metricId]);
        const yAxis = ((_vis$params$valueAxes2 = vis.params.valueAxes) !== null && _vis$params$valueAxes2 !== void 0 ? _vis$params$valueAxes2 : vis.type.visConfig.defaults.valueAxes).find(axis => axis.id === (serie === null || serie === void 0 ? void 0 : serie.valueAxis));
        return {
          forAccessor: metricId,
          axisMode: (0, _common.getYAxisPosition)((_yAxis$position = yAxis === null || yAxis === void 0 ? void 0 : yAxis.position) !== null && _yAxis$position !== void 0 ? _yAxis$position : 'left'),
          color: !splitAccessor && serie !== null && serie !== void 0 && serie.data.label ? overwriteColors[serie === null || serie === void 0 ? void 0 : serie.data.label] : undefined
        };
      }),
      xScaleType: getXScaleType(xColumn),
      isHistogram,
      collapseFn: layer.collapseFn
    };
  });
}
function getReferenceLineLayers(layers, vis) {
  var _vis$params$threshold, _vis$params$valueAxes3;
  const thresholdLineConfig = (_vis$params$threshold = vis.params.thresholdLine) !== null && _vis$params$threshold !== void 0 ? _vis$params$threshold : vis.type.visConfig.defaults.thresholdLine;
  // threshold line is always assigned to the first value axis
  const yAxis = ((_vis$params$valueAxes3 = vis.params.valueAxes) !== null && _vis$params$valueAxes3 !== void 0 ? _vis$params$valueAxes3 : vis.type.visConfig.defaults.valueAxes)[0];
  return layers.map(layer => {
    return {
      layerType: 'referenceLine',
      layerId: layer.layerId,
      accessors: layer.metrics,
      yConfig: layer.metrics.map(metricId => {
        var _yAxis$position2;
        return {
          forAccessor: metricId,
          axisMode: (0, _common.getYAxisPosition)((_yAxis$position2 = yAxis === null || yAxis === void 0 ? void 0 : yAxis.position) !== null && _yAxis$position2 !== void 0 ? _yAxis$position2 : 'left'),
          color: thresholdLineConfig.color,
          lineWidth: thresholdLineConfig.width !== null ? thresholdLineConfig.width : undefined,
          lineStyle: thresholdLineConfig.style === _types.ThresholdLineStyle.DotDashed || thresholdLineConfig.style === _types.ThresholdLineStyle.Full ? 'solid' : thresholdLineConfig.style
        };
      })
    };
  });
}
const getConfiguration = (layers, series, vis) => {
  var _vis$uiState$get, _vis$params$valueAxes4, _vis$params$valueAxes5, _vis$params$categoryA, _yLeftAxis$show, _yRightAxis$show, _vis$params$fittingFu, _vis$params$addLegend, _vis$params$legendPos, _vis$params$legendSiz, _vis$params$truncateL, _vis$params$maxLegend, _vis$params$labels$sh, _vis$type$visConfig$d, _vis$params$fillOpaci, _vis$params$grid$cate, _vis$type$visConfig$d2, _vis$params$grid$valu, _vis$type$visConfig$d3, _vis$params$grid$valu2, _vis$type$visConfig$d4, _xAxis$labels$show, _yLeftAxis$labels$sho, _yRightAxis$labels$sh, _getYScaleType, _getYScaleType2, _vis$params$labels$sh2, _vis$type$visConfig$d5, _vis$params$addTimeMa, _series$, _series$2;
  const legendDisplayFromUiState = (_vis$uiState$get = vis.uiState.get('vis.legendOpen')) !== null && _vis$uiState$get !== void 0 ? _vis$uiState$get : true;
  const yRightAxis = ((_vis$params$valueAxes4 = vis.params.valueAxes) !== null && _vis$params$valueAxes4 !== void 0 ? _vis$params$valueAxes4 : vis.type.visConfig.defaults.valueAxes).find(axis => (0, _common.getYAxisPosition)(axis.position) === _charts.Position.Right);
  const yLeftAxis = ((_vis$params$valueAxes5 = vis.params.valueAxes) !== null && _vis$params$valueAxes5 !== void 0 ? _vis$params$valueAxes5 : vis.type.visConfig.defaults.valueAxes).find(axis => (0, _common.getYAxisPosition)(axis.position) === _charts.Position.Left);
  // as we have only one x-axis
  const xAxis = ((_vis$params$categoryA = vis.params.categoryAxes) !== null && _vis$params$categoryA !== void 0 ? _vis$params$categoryA : vis.type.visConfig.defaults.categoryAxes)[0];
  const axisTitlesVisibilitySettings = {
    x: xAxis.show,
    yLeft: (_yLeftAxis$show = yLeftAxis === null || yLeftAxis === void 0 ? void 0 : yLeftAxis.show) !== null && _yLeftAxis$show !== void 0 ? _yLeftAxis$show : true,
    yRight: (_yRightAxis$show = yRightAxis === null || yRightAxis === void 0 ? void 0 : yRightAxis.show) !== null && _yRightAxis$show !== void 0 ? _yRightAxis$show : true
  };
  const xColumn = layers[0].columns.find(c => c.isBucketed && !c.isSplit);
  const isTimeChart = (xColumn === null || xColumn === void 0 ? void 0 : xColumn.operationType) === 'date_histogram';
  const fittingFunction = (_vis$params$fittingFu = vis.params.fittingFunction) !== null && _vis$params$fittingFu !== void 0 ? _vis$params$fittingFu : vis.type.visConfig.defaults.fittingFunction;
  return {
    layers: [...getDataLayers(layers.filter(l => !l.isReferenceLineLayer), series, vis), ...getReferenceLineLayers(layers.filter(l => l.isReferenceLineLayer), vis)],
    legend: {
      isVisible: legendDisplayFromUiState && ((_vis$params$addLegend = vis.params.addLegend) !== null && _vis$params$addLegend !== void 0 ? _vis$params$addLegend : vis.type.visConfig.defaults.addLegend),
      position: (_vis$params$legendPos = vis.params.legendPosition) !== null && _vis$params$legendPos !== void 0 ? _vis$params$legendPos : vis.type.visConfig.defaults.legendPosition,
      legendSize: (_vis$params$legendSiz = vis.params.legendSize) !== null && _vis$params$legendSiz !== void 0 ? _vis$params$legendSiz : vis.type.visConfig.defaults.legendSize,
      shouldTruncate: (_vis$params$truncateL = vis.params.truncateLegend) !== null && _vis$params$truncateL !== void 0 ? _vis$params$truncateL : vis.type.visConfig.defaults.truncateLegend,
      maxLines: (_vis$params$maxLegend = vis.params.maxLegendLines) !== null && _vis$params$maxLegend !== void 0 ? _vis$params$maxLegend : vis.type.visConfig.defaults.maxLegendLines,
      showSingleSeries: true,
      legendStats: Boolean((_vis$params$labels$sh = vis.params.labels.show) !== null && _vis$params$labels$sh !== void 0 ? _vis$params$labels$sh : (_vis$type$visConfig$d = vis.type.visConfig.defaults.labels) === null || _vis$type$visConfig$d === void 0 ? void 0 : _vis$type$visConfig$d.show) ? [_charts.LegendValue.CurrentAndLastValue] : undefined
    },
    fittingFunction: fittingFunction ? fittingFunction[0].toUpperCase() + fittingFunction.slice(1) : undefined,
    fillOpacity: (_vis$params$fillOpaci = vis.params.fillOpacity) !== null && _vis$params$fillOpaci !== void 0 ? _vis$params$fillOpaci : vis.type.visConfig.defaults.fillOpacity,
    gridlinesVisibilitySettings: {
      x: (_vis$params$grid$cate = vis.params.grid.categoryLines) !== null && _vis$params$grid$cate !== void 0 ? _vis$params$grid$cate : (_vis$type$visConfig$d2 = vis.type.visConfig.defaults.grid) === null || _vis$type$visConfig$d2 === void 0 ? void 0 : _vis$type$visConfig$d2.categoryLines,
      yLeft: ((_vis$params$grid$valu = vis.params.grid.valueAxis) !== null && _vis$params$grid$valu !== void 0 ? _vis$params$grid$valu : (_vis$type$visConfig$d3 = vis.type.visConfig.defaults.grid) === null || _vis$type$visConfig$d3 === void 0 ? void 0 : _vis$type$visConfig$d3.valueAxis) === (yLeftAxis === null || yLeftAxis === void 0 ? void 0 : yLeftAxis.id),
      yRight: ((_vis$params$grid$valu2 = vis.params.grid.valueAxis) !== null && _vis$params$grid$valu2 !== void 0 ? _vis$params$grid$valu2 : (_vis$type$visConfig$d4 = vis.type.visConfig.defaults.grid) === null || _vis$type$visConfig$d4 === void 0 ? void 0 : _vis$type$visConfig$d4.valueAxis) === (yRightAxis === null || yRightAxis === void 0 ? void 0 : yRightAxis.id)
    },
    axisTitlesVisibilitySettings,
    tickLabelsVisibilitySettings: {
      x: axisTitlesVisibilitySettings.x && ((_xAxis$labels$show = xAxis.labels.show) !== null && _xAxis$labels$show !== void 0 ? _xAxis$labels$show : true),
      yLeft: axisTitlesVisibilitySettings.yLeft && ((_yLeftAxis$labels$sho = yLeftAxis === null || yLeftAxis === void 0 ? void 0 : yLeftAxis.labels.show) !== null && _yLeftAxis$labels$sho !== void 0 ? _yLeftAxis$labels$sho : true),
      yRight: axisTitlesVisibilitySettings.yRight && ((_yRightAxis$labels$sh = yRightAxis === null || yRightAxis === void 0 ? void 0 : yRightAxis.labels.show) !== null && _yRightAxis$labels$sh !== void 0 ? _yRightAxis$labels$sh : true)
    },
    labelsOrientation: {
      x: getLabelOrientation(xAxis, isTimeChart),
      yLeft: getLabelOrientation(yLeftAxis),
      yRight: getLabelOrientation(yRightAxis)
    },
    yLeftScale: (_getYScaleType = getYScaleType(yLeftAxis === null || yLeftAxis === void 0 ? void 0 : yLeftAxis.scale)) !== null && _getYScaleType !== void 0 ? _getYScaleType : _charts.ScaleType.Linear,
    yRightScale: (_getYScaleType2 = getYScaleType(yRightAxis === null || yRightAxis === void 0 ? void 0 : yRightAxis.scale)) !== null && _getYScaleType2 !== void 0 ? _getYScaleType2 : _charts.ScaleType.Linear,
    yLeftExtent: yLeftAxis !== null && yLeftAxis !== void 0 && yLeftAxis.scale ? getExtents(yLeftAxis, series) : undefined,
    yRightExtent: yRightAxis !== null && yRightAxis !== void 0 && yRightAxis.scale ? getExtents(yRightAxis, series) : undefined,
    yTitle: yLeftAxis === null || yLeftAxis === void 0 ? void 0 : yLeftAxis.title.text,
    yRightTitle: yRightAxis === null || yRightAxis === void 0 ? void 0 : yRightAxis.title.text,
    xTitle: xAxis.title.text,
    valueLabels: ((_vis$params$labels$sh2 = vis.params.labels.show) !== null && _vis$params$labels$sh2 !== void 0 ? _vis$params$labels$sh2 : (_vis$type$visConfig$d5 = vis.type.visConfig.defaults.labels) === null || _vis$type$visConfig$d5 === void 0 ? void 0 : _vis$type$visConfig$d5.show) ? 'show' : 'hide',
    showCurrentTimeMarker: isTimeChart ? Boolean((_vis$params$addTimeMa = vis.params.addTimeMarker) !== null && _vis$params$addTimeMa !== void 0 ? _vis$params$addTimeMa : vis.type.visConfig.defaults.addTimeMarker) : undefined,
    curveType: (0, _common.getCurveType)(((_series$ = series[0]) === null || _series$ === void 0 ? void 0 : _series$.interpolate) === _types.InterpolationMode.StepAfter ? _types.InterpolationMode.Linear : (_series$2 = series[0]) === null || _series$2 === void 0 ? void 0 : _series$2.interpolate)
  };
};
exports.getConfiguration = getConfiguration;