"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownPanelConfig = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _series_editor = require("../series_editor");
var _index_pattern = require("../index_pattern");
var _create_select_handler = require("../lib/create_select_handler");
var _color_picker = require("../color_picker");
var _yes_no = require("../yes_no");
var _markdown_editor = require("../markdown_editor");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _get_default_query_language = require("../lib/get_default_query_language");
var _vis_data_context = require("../../contexts/vis_data_context");
var _types = require("./types");
var _panel_config = require("./_panel_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class MarkdownPanelConfig extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedTab: _types.PANEL_CONFIG_TABS.MARKDOWN
    };
    this.handleCSSChange = this.handleCSSChange.bind(this);
  }
  switchTab(selectedTab) {
    this.setState({
      selectedTab
    });
  }
  handleCSSChange(value) {
    this.props.onChange({
      markdown_css: value
    });
  }
  render() {
    const defaults = {
      filter: {
        query: '',
        language: (0, _get_default_query_language.getDefaultQueryLanguage)()
      }
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const {
      selectedTab
    } = this.state;
    const handleSelectChange = (0, _create_select_handler.createSelectHandler)(this.props.onChange);
    const htmlId = (0, _eui.htmlIdGenerator)();
    const alignOptions = [{
      label: _i18n.i18n.translate('visTypeTimeseries.markdown.alignOptions.topLabel', {
        defaultMessage: 'Top'
      }),
      value: 'top'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.markdown.alignOptions.middleLabel', {
        defaultMessage: 'Middle'
      }),
      value: 'middle'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.markdown.alignOptions.bottomLabel', {
        defaultMessage: 'Bottom'
      }),
      value: 'bottom'
    }];
    const selectedAlignOption = alignOptions.find(option => {
      return model.markdown_vertical_align === option.value;
    });
    let view;
    if (selectedTab === _types.PANEL_CONFIG_TABS.MARKDOWN) {
      view = /*#__PURE__*/_react.default.createElement(_vis_data_context.VisDataContext.Consumer, null, visData => /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownEditor, (0, _extends2.default)({
        visData: visData
      }, this.props)));
    } else if (selectedTab === _types.PANEL_CONFIG_TABS.DATA) {
      view = /*#__PURE__*/_react.default.createElement(_series_editor.SeriesEditor, {
        colorPicker: false,
        fields: this.props.fields,
        model: this.props.model,
        onChange: this.props.onChange
      });
    } else {
      var _model$filter, _model$filter2, _model$markdown_css;
      view = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbPanelConfig__container",
        css: _panel_config.panelConfigContainerStyles
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.markdown.optionsTab.dataLabel",
        defaultMessage: "Data"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
        fields: this.props.fields,
        model: this.props.model,
        onChange: this.props.onChange,
        allowIndexSwitchingMode: true
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: htmlId('panelFilter'),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.markdown.optionsTab.panelFilterLabel",
          defaultMessage: "Panel filter"
        }),
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
        query: {
          language: ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
          query: ((_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.query) || ''
        },
        onChange: filter => {
          this.props.onChange({
            filter
          });
        },
        indexPatterns: [model.index_pattern]
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('visTypeTimeseries.markdown.optionsTab.ignoreGlobalFilterLabel', {
          defaultMessage: 'Ignore global filter?'
        })
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.ignore_global_filter,
        name: "ignore_global_filter",
        onChange: this.props.onChange
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.markdown.optionsTab.styleLabel",
        defaultMessage: "Style"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true,
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.markdown.optionsTab.backgroundColorLabel",
        defaultMessage: "Background color:"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
        onChange: this.props.onChange,
        name: "background_color",
        value: model.background_color
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('visTypeTimeseries.markdown.optionsTab.showScrollbarsLabel', {
          defaultMessage: 'Show scrollbars?'
        })
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.markdown_scrollbars,
        name: "markdown_scrollbars",
        onChange: this.props.onChange
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('visTypeTimeseries.markdown.optionsTab.openLinksInNewTab', {
          defaultMessage: 'Open links in new tab?'
        })
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.markdown_openLinksInNewTab,
        name: "markdown_openLinksInNewTab",
        onChange: this.props.onChange
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        htmlFor: htmlId('valign')
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.markdown.optionsTab.verticalAlignmentLabel",
        defaultMessage: "Vertical alignment:"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        id: htmlId('valign'),
        isClearable: false,
        options: alignOptions,
        selectedOptions: selectedAlignOption ? [selectedAlignOption] : [],
        onChange: handleSelectChange('markdown_vertical_align'),
        singleSelection: {
          asPlainText: true
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxs"
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.markdown.optionsTab.customCSSLabel",
        defaultMessage: "Custom CSS",
        description: "CSS is name of technology and should not be translated."
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
        height: "500px",
        languageId: _codeEditor.CSS_LANG_ID,
        options: {
          fontSize: 14
        },
        value: (_model$markdown_css = model.markdown_css) !== null && _model$markdown_css !== void 0 ? _model$markdown_css : '',
        onChange: this.handleCSSChange
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.MARKDOWN,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.MARKDOWN),
      "data-test-subj": "markdown-subtab"
    }, "Markdown"), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": "data-subtab",
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.DATA,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.DATA)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdown.dataTab.dataButtonLabel",
      defaultMessage: "Data"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.OPTIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.OPTIONS),
      "data-test-subj": "options-subtab"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdown.optionsTab.panelOptionsButtonLabel",
      defaultMessage: "Panel options"
    }))), view);
  }
}
exports.MarkdownPanelConfig = MarkdownPanelConfig;