"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _i18n = require("@kbn/i18n");
var _alter = _interopRequireDefault(require("../lib/alter"));
var _chainable = _interopRequireDefault(require("../lib/classes/chainable"));
var _re2js = require("re2js");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var _default = exports.default = new _chainable.default('label', {
  args: [{
    name: 'inputSeries',
    types: ['seriesList']
  }, {
    name: 'label',
    types: ['string'],
    help: _i18n.i18n.translate('timelion.help.functions.label.args.labelHelpText', {
      defaultMessage: 'Legend value for series. You can use $1, $2, etc, in the string to match up with the regex capture groups',
      description: '"$1" and "$2" are part of the expression and must not be translated.'
    })
  }, {
    name: 'regex',
    types: ['string', 'null'],
    help: _i18n.i18n.translate('timelion.help.functions.label.args.regexHelpText', {
      defaultMessage: 'A regex with capture group support'
    })
  }],
  help: _i18n.i18n.translate('timelion.help.functions.labelHelpText', {
    defaultMessage: 'Change the label of the series. Use %s to reference the existing label'
  }),
  fn: function labelFn(args) {
    const config = args.byName;
    return (0, _alter.default)(args, function (eachSeries) {
      if (config.regex) {
        eachSeries.label = _re2js.RE2JS.compile(config.regex).matcher(eachSeries.label).replaceAll(config.label);
      } else if (config.label) {
        eachSeries.label = config.label;
      }
      return eachSeries;
    });
  }
});
module.exports = exports.default;