"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMarkdownVisFn = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createMarkdownVisFn = () => ({
  name: 'markdownVis',
  type: 'render',
  inputTypes: [],
  help: _i18n.i18n.translate('visTypeMarkdown.function.help', {
    defaultMessage: 'Markdown visualization'
  }),
  args: {
    markdown: {
      types: ['string'],
      aliases: ['_'],
      required: true,
      help: _i18n.i18n.translate('visTypeMarkdown.function.markdown.help', {
        defaultMessage: 'Markdown to render'
      })
    },
    font: {
      types: ['style'],
      help: _i18n.i18n.translate('visTypeMarkdown.function.font.help', {
        defaultMessage: 'Font settings.'
      }),
      default: `{font size=12}`
    },
    openLinksInNewTab: {
      types: ['boolean'],
      default: false,
      help: _i18n.i18n.translate('visTypeMarkdown.function.openLinksInNewTab.help', {
        defaultMessage: 'Opens links in new tab'
      })
    }
  },
  fn(input, args) {
    return {
      type: 'render',
      as: 'markdown_vis',
      value: {
        visType: 'markdown',
        visParams: {
          markdown: args.markdown,
          openLinksInNewTab: args.openLinksInNewTab,
          fontSize: parseInt(args.font.spec.fontSize || '12', 10)
        }
      }
    };
  }
});
exports.createMarkdownVisFn = createMarkdownVisFn;